/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.cim;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.cim.CimErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.managed.cim.CimProvider;
import com.ibm.hwmca.fw.util.ClassDescriptors;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMElement;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMMethod;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMParameter;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMQualifier;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.client.CIMClient;
import org.snia.wbemcmd.mof.MOFParse;
import org.snia.wbemcmd.mof.MOFStatus;

public class CimClassGenerator
implements MOFStatus,
CimErrorIds {
    private ClassDescriptors descriptors;
    private CIMClient cimClient;
    private String classOrigin;
    private File passwordFile = null;
    Node rootNode = new Node();
    private boolean mofError;
    private static String cimomPath;
    private static final String SCHEMA_CONFIG_FILE = "basecomp";
    private static final String[] MOF_FILES;
    private static final FrameworkClassLogInfo logInfo;
    private static final String TRACE_MASKT = "XCIMCG T";
    private static final String TRACE_MASKF = "XCIMCG F";
    private static final String TRACE_MASKD = "XCIMCG D";

    public CimClassGenerator() throws CIMException {
        Trace.trace(TRACE_MASKT, "-> CimClassGenerator()");
        this.descriptors = ClassDescriptors.getClassDescriptors("CIM");
        this.connectToCimom();
        Trace.trace(TRACE_MASKT, "<- CimClassGenerator()");
    }

    public void generateClasses() {
        Trace.trace(TRACE_MASKT, "-> generateClasses()");
        Iterator iterator = this.descriptors.getDescriptors().iterator();
        while (iterator.hasNext()) {
            CIMClass cimClass = (CIMClass)iterator.next();
            if (cimClass.getQualifier("HWMCA_CIMSUPERCLASS") == null) continue;
            this.generateClass(cimClass);
        }
        this.rootNode.addToCimom();
        if (this.passwordFile != null) {
            this.passwordFile.delete();
        }
        Trace.trace(TRACE_MASKF, "Temporary password file deleted");
        Trace.trace(TRACE_MASKT, "<- generateClasses()");
    }

    public void fileOpened(String filename) {
        Trace.trace("XCIMMC F", "Processing file " + filename);
    }

    public void filePercent(int percent) {
    }

    public void setMessage(String message) {
        Trace.trace("XCIMMC F", message);
    }

    public int errorHandler(String error) {
        Trace.trace("XCIMMC F", "Error: " + error);
        FrameworkLog log = new FrameworkLog(logInfo, 656);
        log.add(error);
        log.log();
        this.mofError = true;
        return -1;
    }

    private void connectToCimom() throws CIMException {
        Trace.trace(TRACE_MASKT, "-> connectToCimom()");
        try {
            String password = UUIDFactory.generate().toString();
            cimomPath = BaseFileControl.getFilePath("cimom");
            String passwordFileName = cimomPath + "managerpw";
            this.passwordFile = new File(passwordFileName);
            FileOutputStream stream = new FileOutputStream(this.passwordFile);
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            writer.write(password);
            writer.close();
            Trace.trace(TRACE_MASKF, "Temporary password file \"" + passwordFileName + "\" created");
            CIMNameSpace namespace = new CIMNameSpace();
            namespace.setNameSpace("root");
            this.cimClient = new CIMClient(namespace, "_MANAGER_", password);
            for (int ix = 0; ix < 10; ++ix) {
                try {
                    this.cimClient.enumNameSpace(new CIMObjectPath("", "root"), false);
                    Trace.trace(TRACE_MASKF, "connected to the CIMOM");
                    break;
                }
                catch (CIMException exc) {
                    Trace.trace(TRACE_MASKF, "Attempt " + ix + " to connect to the CIMOM failed");
                    Object[] parms = exc.getParams();
                    if (!exc.getID().equals("CIM_ERR_FAILED") || parms.length < 1 || !(parms[0] instanceof String) || ((String)parms[0]).indexOf("ConnectException") < 0 || ix >= 19) {
                        Trace.trace(TRACE_MASKF, (Object)exc);
                        throw exc;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException exc2) {
                        // empty catch block
                    }
                    continue;
                }
            }
            this.loadSchema(this.cimClient);
        }
        catch (Exception exc) {
            new FrameworkLog(logInfo, 656, exc).log(LogAttributes.INFO_LOG);
            throw new CIMException("CIM_ERR_FAILED", (Object)"An error occurred while connecting to the CIMOM");
        }
        Trace.trace(TRACE_MASKT, "<- connectToCimom()");
    }

    private void loadSchema(CIMClient cimClient) {
        block10: {
            Trace.trace(TRACE_MASKT, "-> loadSchema()");
            try {
                String configFileName = cimomPath + SCHEMA_CONFIG_FILE;
                Trace.trace(TRACE_MASKF, "Reading config file: " + configFileName);
                File configFile = new File(configFileName);
                if (!configFile.canRead()) break block10;
                FileInputStream inStream = new FileInputStream(configFile);
                InputStreamReader reader = new InputStreamReader(inStream);
                int compileOption = reader.read();
                reader.close();
                Trace.trace(TRACE_MASKF, "Config file contents: " + (char)compileOption);
                if (compileOption == 48) break block10;
                HashSet<CIMClass> classSet = new HashSet<CIMClass>();
                Enumeration classes = cimClient.enumClass(new CIMObjectPath(null, "root"), true);
                while (classes.hasMoreElements()) {
                    CIMObjectPath classPath = (CIMObjectPath)classes.nextElement();
                    if (classPath.getObjectName().equalsIgnoreCase("__namespace")) continue;
                    classSet.add(cimClient.getClass(classPath, true));
                }
                while (!classSet.isEmpty()) {
                    Iterator iterator1 = classSet.iterator();
                    while (iterator1.hasNext()) {
                        CIMClass class1 = (CIMClass)iterator1.next();
                        String className1 = class1.getName();
                        boolean isDerived = false;
                        Iterator iterator2 = classSet.iterator();
                        while (iterator2.hasNext() && !isDerived) {
                            CIMClass class2 = (CIMClass)iterator2.next();
                            String superClass = class2.getSuperClass();
                            isDerived = superClass != null && superClass.equalsIgnoreCase(className1);
                        }
                        if (isDerived) continue;
                        try {
                            CIMObjectPath path = new CIMObjectPath(className1, "root");
                            Trace.trace(TRACE_MASKF, "Removing class: " + path.getObjectName());
                            cimClient.deleteClass(path);
                        }
                        catch (Exception exc) {
                            Trace.trace(TRACE_MASKF, "Class: " + class1.getName() + " was not removed");
                            Trace.trace(TRACE_MASKF, exc.toString());
                        }
                        iterator1.remove();
                    }
                }
                this.mofError = false;
                CIMNameSpace nameSpace = new CIMNameSpace("localhost", "root");
                MOFParse parser = new MOFParse();
                for (int ix = 0; ix < MOF_FILES.length && !this.mofError; ++ix) {
                    parser.mofParse(cimClient, nameSpace, cimomPath, MOF_FILES[ix], (MOFStatus)this, false);
                }
                if (!this.mofError) {
                    FileOutputStream outStream = new FileOutputStream(configFile);
                    OutputStreamWriter writer = new OutputStreamWriter(outStream);
                    writer.write(48);
                    writer.close();
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        Trace.trace(TRACE_MASKT, "<- loadSchema()");
    }

    private void generateClass(CIMClass javaClass) {
        Trace.trace(TRACE_MASKF, "-> generateClass(javaClass=" + javaClass.getName() + ")");
        CIMClass cimClass = new CIMClass();
        cimClass.setName(CimProvider.toCimName((CIMElement)javaClass));
        String superClass = (String)javaClass.getQualifier("HWMCA_CIMSUPERCLASS").getValue().getValue();
        cimClass.setSuperClass(superClass);
        while (javaClass != null) {
            if (javaClass.getQualifier("HWMCA_CIMSUPERCLASS") != null) {
                this.classOrigin = CimProvider.toCimName((CIMElement)javaClass);
            }
            this.addQualifiers(javaClass.getQualifiers().iterator(), (CIMElement)cimClass);
            this.addProperties(javaClass, cimClass, null, false);
            this.addMethods(javaClass, cimClass);
            javaClass = this.descriptors.findClass(javaClass.getSuperClass());
        }
        Trace.trace(TRACE_MASKD, "generated class:\n" + cimClass);
        this.rootNode.addChild(cimClass);
        Trace.trace(TRACE_MASKF, "<- generateClass()");
    }

    private void addQualifiers(Iterator iterator, CIMElement toElement) {
        Trace.trace(TRACE_MASKF, "-> addQualifiers(toElement=" + toElement + ")");
        while (iterator.hasNext()) {
            CIMQualifier cimQualifier = (CIMQualifier)iterator.next();
            String name = cimQualifier.getName();
            if (name.startsWith("HWMCA_")) continue;
            this.addQualifier(toElement, cimQualifier);
        }
        Trace.trace(TRACE_MASKF, "<- addQualifiers()");
    }

    private void addProperties(CIMClass fromClass, CIMClass toClass, String propertyNamePrefix, boolean makeArrays) {
        String includeClassName;
        CIMClass includedClass;
        Trace.trace(TRACE_MASKF, "-> addProperties(fromClass=" + fromClass.getName() + ",toClass=" + toClass.getName() + ",propertyNamePrefix=" + propertyNamePrefix + ",makeArrays=" + makeArrays + ")");
        Iterator iterator = fromClass.getAllProperties().iterator();
        while (iterator.hasNext()) {
            CIMClass referenceClass;
            CIMProperty cimProperty = (CIMProperty)iterator.next();
            Trace.trace(TRACE_MASKD, "original property:\n" + cimProperty);
            if (propertyNamePrefix == null) {
                propertyNamePrefix = "";
            }
            String name = CimProvider.toCimName((CIMElement)cimProperty);
            name = propertyNamePrefix + name.substring(0, 1).toUpperCase() + name.substring(1);
            CIMDataType type = cimProperty.getType();
            if (type.isReferenceType() && (referenceClass = this.descriptors.findClass(type.getRefClassName())) != null) {
                if (makeArrays) {
                    Trace.trace(TRACE_MASKF, "Nested property \"" + name + "\" of aggregate class \"" + fromClass.getName() + "\" cannot be aggregate.");
                    continue;
                }
                CIMQualifier aggregateQual = cimProperty.getQualifier("AGGREGATE");
                boolean aggregate = aggregateQual != null && (aggregateQual.getValue() == null || ((String)aggregateQual.getValue().getValue()).equalsIgnoreCase("TRUE"));
                this.addProperties(referenceClass, toClass, name + "_", aggregate);
                continue;
            }
            CIMProperty overriddenProperty = toClass.getProperty(name);
            if (overriddenProperty != null && overriddenProperty.getQualifier("OVERRIDE") != null) {
                Trace.trace(TRACE_MASKD, "skipping overridden property:\n" + cimProperty);
                continue;
            }
            CIMProperty newProperty = new CIMProperty(name);
            CIMDataType cimType = CimProvider.toCimType((CIMElement)cimProperty);
            if (makeArrays) {
                cimType = new CIMDataType(CIMDataType.findArrayType((int)cimType.getType()));
            }
            newProperty.setType(cimType);
            CIMValue value = CimProvider.toCimValue(cimProperty.getValue(), (CIMElement)cimProperty);
            newProperty.setValue(value);
            newProperty.setOriginClass(this.classOrigin);
            CIMQualifier cimQualifier = cimProperty.getQualifier("HWMCA_READONLY");
            if (!ClassDescriptors.containsAppl(cimQualifier, "CIM")) {
                cimQualifier = new CIMQualifier("WRITE");
                cimQualifier.setValue(new CIMValue((Object)new Boolean(true)));
                try {
                    newProperty.addQualifier(cimQualifier);
                }
                catch (CIMException exc) {
                    Trace.trace(TRACE_MASKF, "Ignored duplicate qualifier: " + cimQualifier);
                }
            }
            this.addQualifiers(cimProperty.getQualifiers().iterator(), (CIMElement)newProperty);
            toClass.addProperty(newProperty);
            Trace.trace(TRACE_MASKD, "added property:\n" + newProperty);
        }
        CIMQualifier cimQualifier = fromClass.getQualifier("HWMCA_INCLUDEPROPERTIES");
        if (cimQualifier != null && (includedClass = this.descriptors.findClass(includeClassName = (String)cimQualifier.getValue().getValue())) != null) {
            this.addProperties(includedClass, toClass, propertyNamePrefix, makeArrays);
        }
        Trace.trace(TRACE_MASKF, "<- addProperties()");
    }

    private void addMethods(CIMClass fromClass, CIMClass toClass) {
        String includeClassName;
        CIMClass includedClass;
        Trace.trace(TRACE_MASKF, "-> addMethods()");
        Iterator iterator = fromClass.getAllMethods().iterator();
        while (iterator.hasNext()) {
            CIMMethod cimMethod = (CIMMethod)iterator.next();
            if (cimMethod.getQualifier("HWMCA_GETMETHODFOR") != null || cimMethod.getQualifier("HWMCA_SETMETHODFOR") != null) {
                Trace.trace(TRACE_MASKD, "Ignoring property accessor method:" + cimMethod.getName());
                continue;
            }
            String javaName = cimMethod.getName();
            String propertyName = null;
            if (javaName.startsWith("get")) {
                propertyName = javaName.substring(3, 4).toLowerCase() + javaName.substring(4);
            } else if (javaName.startsWith("set")) {
                propertyName = javaName.substring(3, 4).toLowerCase() + javaName.substring(4);
            } else if (javaName.startsWith("is")) {
                propertyName = javaName.substring(2, 3).toLowerCase() + javaName.substring(3);
            }
            if (propertyName != null) {
                boolean found = false;
                Iterator properties = toClass.getAllProperties().iterator();
                while (!found && properties.hasNext()) {
                    CIMProperty property = (CIMProperty)properties.next();
                    String classPropertyName = property.getName();
                    int seperator = classPropertyName.indexOf(95);
                    if (seperator == -1) {
                        found = propertyName.equalsIgnoreCase(classPropertyName);
                        continue;
                    }
                    found = propertyName.equalsIgnoreCase(classPropertyName.substring(0, seperator));
                }
                if (found) {
                    Trace.trace(TRACE_MASKD, "Ignoring property accessor method:" + cimMethod.getName());
                    continue;
                }
            }
            Trace.trace(TRACE_MASKD, "original method:\n" + cimMethod);
            String name = CimProvider.toCimName((CIMElement)cimMethod);
            CIMMethod overriddenMethod = toClass.getMethod(name);
            if (overriddenMethod != null && overriddenMethod.getQualifier("OVERRIDE") != null) {
                Trace.trace(TRACE_MASKD, "skipping overridden method:\n" + cimMethod);
                continue;
            }
            CIMMethod newMethod = new CIMMethod(name);
            newMethod.setOriginClass(this.classOrigin);
            this.addParameters(cimMethod, newMethod);
            this.addQualifiers(cimMethod.getQualifiers().iterator(), (CIMElement)newMethod);
            toClass.addMethod(newMethod);
            Trace.trace(TRACE_MASKD, "added method:\n" + newMethod);
        }
        CIMQualifier cimQualifier = fromClass.getQualifier("HWMCA_INCLUDEPROPERTIES");
        if (cimQualifier != null && (includedClass = this.descriptors.findClass(includeClassName = (String)cimQualifier.getValue().getValue())) != null) {
            this.addMethods(includedClass, toClass);
        }
        Trace.trace(TRACE_MASKF, "<- addMethods()");
    }

    private void addParameters(CIMMethod fromMethod, CIMMethod toMethod) {
        Trace.trace(TRACE_MASKF, "-> addParameters()");
        Vector<CIMParameter> parameters = new Vector<CIMParameter>();
        Iterator iterator = fromMethod.getParameters().iterator();
        while (iterator.hasNext()) {
            CIMParameter cimParameter = (CIMParameter)iterator.next();
            Trace.trace(TRACE_MASKD, "original parameter:\n" + cimParameter.toMOF());
            String name = CimProvider.toCimName((CIMElement)cimParameter);
            if (name.equals("HWMCA_RETURN_REFERENCE")) {
                toMethod.setType(CimProvider.toCimType((CIMElement)cimParameter));
                continue;
            }
            CIMParameter newParameter = new CIMParameter(name);
            newParameter.setType(CimProvider.toCimType((CIMElement)cimParameter));
            this.addQualifiers(cimParameter.getQualifiers().iterator(), (CIMElement)newParameter);
            parameters.add(newParameter);
            Trace.trace(TRACE_MASKD, "added parameter:\n" + newParameter);
        }
        toMethod.setParameters(parameters);
        Trace.trace(TRACE_MASKF, "<- addParameters()");
    }

    private CIMQualifier getQualifier(CIMElement element, String name) {
        CIMQualifier result = null;
        if (element instanceof CIMClass) {
            result = ((CIMClass)element).getQualifier(name);
        } else if (element instanceof CIMProperty) {
            result = ((CIMProperty)element).getQualifier(name);
        } else if (element instanceof CIMMethod) {
            result = ((CIMMethod)element).getQualifier(name);
        } else if (element instanceof CIMParameter) {
            result = ((CIMParameter)element).getQualifier(name);
        }
        return result;
    }

    private void addQualifier(CIMElement element, CIMQualifier qualifier) {
        if (this.getQualifier(element, qualifier.getName()) == null) {
            if (element instanceof CIMClass) {
                ((CIMClass)element).addQualifier(qualifier);
            } else if (element instanceof CIMProperty) {
                Vector<CIMQualifier> qualifiers = ((CIMProperty)element).getQualifiers();
                if (qualifiers == null) {
                    qualifiers = new Vector<CIMQualifier>();
                }
                qualifiers.add(qualifier);
                ((CIMProperty)element).setQualifiers(qualifiers);
            } else if (element instanceof CIMMethod) {
                Vector<CIMQualifier> qualifiers = ((CIMMethod)element).getQualifiers();
                if (qualifiers == null) {
                    qualifiers = new Vector<CIMQualifier>();
                }
                qualifiers.add(qualifier);
                ((CIMMethod)element).setQualifiers(qualifiers);
            } else if (element instanceof CIMParameter) {
                Vector<CIMQualifier> qualifiers = ((CIMParameter)element).getQualifiers();
                if (qualifiers == null) {
                    qualifiers = new Vector<CIMQualifier>();
                }
                qualifiers.add(qualifier);
                ((CIMParameter)element).setQualifiers(qualifiers);
            }
        }
    }

    static {
        MOF_FILES = new String[]{"CIM_Core27.mof", "CIM_System27.mof"};
        logInfo = new FrameworkClassLogInfo(85, "CimClassGen");
    }

    private class Node {
        private CIMClass cimClass;
        private String name = "root";
        private String superClass;
        private Node parent;
        private Map children;

        public Node() {
        }

        public Node(CIMClass cimClass, Node parent) {
            this.cimClass = cimClass;
            this.parent = parent;
            this.name = cimClass.getName();
            this.superClass = cimClass.getSuperClass();
        }

        public boolean addChild(CIMClass childClass) {
            Node node;
            Trace.trace(CimClassGenerator.TRACE_MASKF, "-> Node.addChild(childClass=" + childClass.getName() + ") to " + (this.cimClass == null ? "root" : this.cimClass.getName()));
            boolean result = false;
            String childName = childClass.getName();
            String childSuperClass = childClass.getSuperClass();
            if (this.cimClass != null && childSuperClass.equals(this.name)) {
                node = new Node(childClass, this);
                if (this.children == null) {
                    this.children = new TreeMap();
                }
                this.children.put(childName, node);
                Trace.trace(CimClassGenerator.TRACE_MASKD, childName + " added as child to " + this.name);
                result = true;
            } else if (this.cimClass != null && childName.equals(this.superClass)) {
                node = new Node(childClass, this.parent);
                node.children = new TreeMap();
                Iterator iterator = this.parent.children.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Node siblingNode = (Node)entry.getValue();
                    if (siblingNode.cimClass == null) continue;
                    String siblingName = siblingNode.cimClass.getName();
                    String siblingSuperClass = siblingNode.cimClass.getSuperClass();
                    if (!childName.equals(siblingSuperClass)) continue;
                    iterator.remove();
                    node.children.put(siblingName, siblingNode);
                    Trace.trace(CimClassGenerator.TRACE_MASKD, siblingName + " removed as child from " + this.parent.name + " and added as child to " + childName);
                }
                this.parent.children.put(childName, node);
                Trace.trace(CimClassGenerator.TRACE_MASKD, childName + " added as child to " + this.parent.name);
                result = true;
            } else if (this.children != null) {
                Iterator iterator = this.children.entrySet().iterator();
                while (!result && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    result = ((Node)entry.getValue()).addChild(childClass);
                }
            }
            if (!result && this.parent == null) {
                node = new Node(childClass, this);
                if (this.children == null) {
                    this.children = new TreeMap();
                }
                this.children.put(childName, node);
                Trace.trace(CimClassGenerator.TRACE_MASKD, childName + " added as child to root");
                result = true;
            }
            Trace.trace(CimClassGenerator.TRACE_MASKF, "<- Node.addChild(returns " + result + ")");
            return result;
        }

        public void addToCimom() {
            try {
                if (this.cimClass != null) {
                    Trace.trace(CimClassGenerator.TRACE_MASKF, "Adding CIM class" + this.cimClass.getName());
                    CIMObjectPath classPath = new CIMObjectPath(this.cimClass.getName(), "root");
                    try {
                        CimClassGenerator.this.cimClient.deleteClass(classPath);
                    }
                    catch (CIMException exc2) {
                        Trace.trace(CimClassGenerator.TRACE_MASKF, "Class deletion failed: " + exc2.getMessage());
                    }
                    CimClassGenerator.this.cimClient.createClass(classPath, this.cimClass);
                }
                if (this.children != null) {
                    Iterator iterator = this.children.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        ((Node)entry.getValue()).addToCimom();
                    }
                }
            }
            catch (CIMException exc) {
                new FrameworkLog(logInfo, 656, exc).log(LogAttributes.INFO_LOG);
            }
        }
    }
}

